#!/usr/bin/env pwsh

################################################################################
# alltests.ps1
#
# Run the battery of Mimicc integration tests in powershell
#
# This script iterates over a given directory looking for integration tests and
# runs them one by one. More specifically it runs the sibling script
# 'runtest.ps1' within the folder of each test case.
#
# There is one input: the path to the folder containing all test cases.
#
# The best way to run this is to with a modified PATH environment that allows
# the runtest.sh script to pick up the mimicc + clang distribution. Example:
#
# PATH=<mimicc-dist>\bin;$PATH .\bin\alltests.ps1 .\tests
#
################################################################################
 

# if no path to tests is provided, assume the tests are at ..\tests
$SCRIPT_DIR=$PSScriptRoot
if ( $args.count -lt "1" ) {
    if ( -not (Get-Item "$SCRIPT_DIR\..\tests") ) {
        throw "no test directory found"
    }
    $TEST_DIR=( Resolve-Path "$SCRIPT_DIR\..\tests" )
} else {
    $TEST_DIR=$args[0]
}

# And run the tests. Note that Get-ChildItem returns the list sorted
$TESTS=(Get-ChildItem -Path $TEST_DIR -Directory)
foreach ( $TEST in $TESTS ) {
    $TEST_NAME=[io.path]::GetFileNameWithoutExtension($TEST.Name)
    $TEST_PATH=$TEST.FullName
    Write-Host "Test '$TEST_NAME'"
    Push-Location $TEST_PATH
    try {
        Invoke-Expression "$SCRIPT_DIR\runtest.ps1 $TEST_NAME"
    } catch { throw "regression failed" }
    Pop-Location
}

exit 0

# SIG # Begin signature block
# MIIWMAYJKoZIhvcNAQcCoIIWITCCFh0CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU2YKLmlAR6ervEMCJg1UHQfUj
# lwagghKNMIIFbzCCBFegAwIBAgIQSPyTtGBVlI02p8mKidaUFjANBgkqhkiG9w0B
# AQwFADB7MQswCQYDVQQGEwJHQjEbMBkGA1UECAwSR3JlYXRlciBNYW5jaGVzdGVy
# MRAwDgYDVQQHDAdTYWxmb3JkMRowGAYDVQQKDBFDb21vZG8gQ0EgTGltaXRlZDEh
# MB8GA1UEAwwYQUFBIENlcnRpZmljYXRlIFNlcnZpY2VzMB4XDTIxMDUyNTAwMDAw
# MFoXDTI4MTIzMTIzNTk1OVowVjELMAkGA1UEBhMCR0IxGDAWBgNVBAoTD1NlY3Rp
# Z28gTGltaXRlZDEtMCsGA1UEAxMkU2VjdGlnbyBQdWJsaWMgQ29kZSBTaWduaW5n
# IFJvb3QgUjQ2MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAjeeUEiIE
# JHQu/xYjApKKtq42haxH1CORKz7cfeIxoFFvrISR41KKteKW3tCHYySJiv/vEpM7
# fbu2ir29BX8nm2tl06UMabG8STma8W1uquSggyfamg0rUOlLW7O4ZDakfko9qXGr
# YbNzszwLDO/bM1flvjQ345cbXf0fEj2CA3bm+z9m0pQxafptszSswXp43JJQ8mTH
# qi0Eq8Nq6uAvp6fcbtfo/9ohq0C/ue4NnsbZnpnvxt4fqQx2sycgoda6/YDnAdLv
# 64IplXCN/7sVz/7RDzaiLk8ykHRGa0c1E3cFM09jLrgt4b9lpwRrGNhx+swI8m2J
# mRCxrds+LOSqGLDGBwF1Z95t6WNjHjZ/aYm+qkU+blpfj6Fby50whjDoA7NAxg0P
# OM1nqFOI+rgwZfpvx+cdsYN0aT6sxGg7seZnM5q2COCABUhA7vaCZEao9XOwBpXy
# bGWfv1VbHJxXGsd4RnxwqpQbghesh+m2yQ6BHEDWFhcp/FycGCvqRfXvvdVnTyhe
# Be6QTHrnxvTQ/PrNPjJGEyA2igTqt6oHRpwNkzoJZplYXCmjuQymMDg80EY2NXyc
# uu7D1fkKdvp+BRtAypI16dV60bV/AK6pkKrFfwGcELEW/MxuGNxvYv6mUKe4e7id
# FT/+IAx1yCJaE5UZkADpGtXChvHjjuxf9OUCAwEAAaOCARIwggEOMB8GA1UdIwQY
# MBaAFKARCiM+lvEH7OKvKe+CpX/QMKS0MB0GA1UdDgQWBBQy65Ka/zWWSC8oQEJw
# IDaRXBeF5jAOBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zATBgNVHSUE
# DDAKBggrBgEFBQcDAzAbBgNVHSAEFDASMAYGBFUdIAAwCAYGZ4EMAQQBMEMGA1Ud
# HwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwuY29tb2RvY2EuY29tL0FBQUNlcnRpZmlj
# YXRlU2VydmljZXMuY3JsMDQGCCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0
# cDovL29jc3AuY29tb2RvY2EuY29tMA0GCSqGSIb3DQEBDAUAA4IBAQASv6Hvi3Sa
# mES4aUa1qyQKDKSKZ7g6gb9Fin1SB6iNH04hhTmja14tIIa/ELiueTtTzbT72ES+
# BtlcY2fUQBaHRIZyKtYyFfUSg8L54V0RQGf2QidyxSPiAjgaTCDi2wH3zUZPJqJ8
# ZsBRNraJAlTH/Fj7bADu/pimLpWhDFMpH2/YGaZPnvesCepdgsaLr4CnvYFIUoQx
# 2jLsFeSmTD1sOXPUC4U5IOCFGmjhp0g4qdE2JXfBjRkWxYhMZn0vY86Y6GnfrDyo
# XZ3JHFuu2PMvdM+4fvbXg50RlmKarkUT2n/cR/vfw1Kf5gZV6Z2M8jpiUbzsJA8p
# 1FiAhORFe1rYMIIGHDCCBASgAwIBAgIQM9cIqJFAUxnipbvTObmtbjANBgkqhkiG
# 9w0BAQwFADBWMQswCQYDVQQGEwJHQjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVk
# MS0wKwYDVQQDEyRTZWN0aWdvIFB1YmxpYyBDb2RlIFNpZ25pbmcgUm9vdCBSNDYw
# HhcNMjEwMzIyMDAwMDAwWhcNMzYwMzIxMjM1OTU5WjBXMQswCQYDVQQGEwJHQjEY
# MBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMS4wLAYDVQQDEyVTZWN0aWdvIFB1Ymxp
# YyBDb2RlIFNpZ25pbmcgQ0EgRVYgUjM2MIIBojANBgkqhkiG9w0BAQEFAAOCAY8A
# MIIBigKCAYEAu9H+HrdCW3j1kKeuLIPxjSHTMIaFe9/TzdkWS6yFxbsBz+KMKBFy
# BHYsgcWrEnpASsUQ6IEUORtfTwf2MDAwfzUl5cBzPUAJlOio+Os5C1XVtgyLHif4
# 3j4iwb/vZe5z7mXdKN27H32bMn+3mVUXqrJJqDwQajrDIbKZqEPXO4KoGWG1Pmpa
# Xbi8nhPQCp71W49pOGjqpR9byiPuC+280B5DQ26wU4zCcypEMW6+j7jGAva7ggQV
# eQxSIOiYJ3Fh7y/k+AL7M1m19MNV59/2CCKuttEJWewBn3OJt0NP1fLZvVZZCd23
# F/bEdIC6h0asBtvbBA3VTrrujAk0GZUb5nATBCXfj7jXhDOMbKYM62i6lU98ROjU
# aY0lecMh8TV3+E+2ElWV0FboGALV7nnIhqFp8RtOlBNqB2Lw0GuZpZdQnhwzoR7u
# YYsFaByO9e4mkIPW/nGFp5ryDRQ+NrUSrXd1esznRjZqkFPLxpRx3gc6IfnWMmfg
# nG5UhqBkoIPLAgMBAAGjggFjMIIBXzAfBgNVHSMEGDAWgBQy65Ka/zWWSC8oQEJw
# IDaRXBeF5jAdBgNVHQ4EFgQUgTKSQSsozUbIxKLGKjkS7EipPxQwDgYDVR0PAQH/
# BAQDAgGGMBIGA1UdEwEB/wQIMAYBAf8CAQAwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
# GgYDVR0gBBMwETAGBgRVHSAAMAcGBWeBDAEDMEsGA1UdHwREMEIwQKA+oDyGOmh0
# dHA6Ly9jcmwuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0NvZGVTaWduaW5nUm9v
# dFI0Ni5jcmwwewYIKwYBBQUHAQEEbzBtMEYGCCsGAQUFBzAChjpodHRwOi8vY3J0
# LnNlY3RpZ28uY29tL1NlY3RpZ29QdWJsaWNDb2RlU2lnbmluZ1Jvb3RSNDYucDdj
# MCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTANBgkqhkiG9w0B
# AQwFAAOCAgEAXzas+/n2cloUt/ALHd7Y/ZcB0v0B7pkthuj2t/A5/9aBSlqnQkoK
# LRWd5pT9xWlKstdL8RYSTPa+kGZliy101KsI92oRAwh3fL5p4bDbnySJA9beXKTg
# sta0z+M41bltzCfWzmQR6BBydtP54OksielJ07OXlgYK4fYKyEGakV2B2DZ3mMqA
# QZeo+JE/Y5+qzVRUS4Dq9Rdm05Rx/Z79RzHj6RqGHdO+INI/sVJfspO9jJUJmHKP
# lQH0mEOlSvsUJqqdNr9ysPzcvYQN7O00qF6VKzgWYwV12fYxLhVr4pSyKtJ0NbWY
# mqP++CsvthdLJ2xa5rl2XtqG3atk1mrqgxiIGzGC9YizlCXAIS8IaQLjTLtMKhEw
# 64F5BuFBlSrUIPYLk+R8dgydHSZrX4QB9iqZza/ex/DkGKJOmy8qDGamknUmvtlA
# NRNvrqY3GnrorRxRYwcqVgZs7X4Y9uPsZHOmbQg2i68Pma51axcrwk1qw1FGQVbp
# j8KN/xNxm9rtntOfq+VFphLFFFpSQZejBgAIxeYc6ieCPDvb5kbE7y0ANRPNNn2d
# 5aonCAXMzsA2DksZT9Bjmm2/xSlTMSLbdVB3htDy+GruawYbPoUjK5fIfnqZQQzd
# WH8OqMMSPTo1m+CdLIwXgVREqHodmJ2Wf1lYplRl/1FCC/hH68/45b8wggb2MIIF
# XqADAgECAhEA5so1uUAO8feM8R1ccr4/kjANBgkqhkiG9w0BAQsFADBXMQswCQYD
# VQQGEwJHQjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMS4wLAYDVQQDEyVTZWN0
# aWdvIFB1YmxpYyBDb2RlIFNpZ25pbmcgQ0EgRVYgUjM2MB4XDTIxMTAxMTAwMDAw
# MFoXDTIyMTAxMTIzNTk1OVowgbQxEjAQBgNVBAUTCTgwMzQ1NzQ2ODETMBEGCysG
# AQQBgjc8AgEDEwJVUzEWMBQGCysGAQQBgjc8AgECEwVUZXhhczEdMBsGA1UEDxMU
# UHJpdmF0ZSBPcmdhbml6YXRpb24xCzAJBgNVBAYTAlVTMRMwEQYDVQQIDApDYWxp
# Zm9ybmlhMRcwFQYDVQQKDA5FdXJiYSBMYWJzIExMQzEXMBUGA1UEAwwORXVyYmEg
# TGFicyBMTEMwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDPZZZ7q/M2
# U58TxYZyfiFyv2r+Dl2O+bqT+VoyXUYz8oqPUydy4qHutx93PK6RAW0/zan3m3Jb
# tIZCgYx40BUX4JzzYti3i7lsoHiBxIR9+gjJFcg8mrgG5PbHvj9z68yszyX+VKKr
# scSIS2xa/nHioTQCd6tRYnqTHMNbbh8Ro4vYlnUpl32asupXKBevmVDw8tFGIFIm
# GwUph18YyA3ICDyBHYosz3YBWfoe65kkXD4mvyisiFTb4irX7qP+W8AuXDgl3IPb
# /19lxKJ1CG9YubUtPQsCdKMuouigP7yIIkfcXkTH0DGf0i4akDYX5g+fNVIYUb3C
# aoMPJ+N6m/wY5OFdPQ6RVghDVMq7KWUYwvCy+4gIA5e3kAFOV6nOURm3IynbBMze
# tRG/IfDgNJFz6hhvl8+B2eXRxcITsOLbmoDQoYMkfTY4FDDE6zRks5JZSc6mHxSf
# PtGuRwwEYIbyLEBxdXLjpxCFAitUeaZbL6qUF5xa3jhIsvenwW6vSPYQVIuBPqso
# erPlpwTDGmQNsduHWP5M4DHj/zb7cPO3ZaILXKJPgZfxNfAWeoU03JHp0rVaV1zp
# YOILvlVRL6hRHa/NP+ZD1yYhy5KuIAcPADmO0fXvNn30fKizpCJggHVpX+qqIEo3
# VCapnHEWGeHhubiR/w6UJUrvWMvO/uz5PQIDAQABo4IB3TCCAdkwHwYDVR0jBBgw
# FoAUgTKSQSsozUbIxKLGKjkS7EipPxQwHQYDVR0OBBYEFPYVvgGj0rX584tupuVe
# eoUVfoAwMA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBMGA1UdJQQMMAoG
# CCsGAQUFBwMDMBEGCWCGSAGG+EIBAQQEAwIEEDBJBgNVHSAEQjBAMDUGDCsGAQQB
# sjEBAgEGATAlMCMGCCsGAQUFBwIBFhdodHRwczovL3NlY3RpZ28uY29tL0NQUzAH
# BgVngQwBAzBLBgNVHR8ERDBCMECgPqA8hjpodHRwOi8vY3JsLnNlY3RpZ28uY29t
# L1NlY3RpZ29QdWJsaWNDb2RlU2lnbmluZ0NBRVZSMzYuY3JsMHsGCCsGAQUFBwEB
# BG8wbTBGBggrBgEFBQcwAoY6aHR0cDovL2NydC5zZWN0aWdvLmNvbS9TZWN0aWdv
# UHVibGljQ29kZVNpZ25pbmdDQUVWUjM2LmNydDAjBggrBgEFBQcwAYYXaHR0cDov
# L29jc3Auc2VjdGlnby5jb20wPAYDVR0RBDUwM6AiBggrBgEFBQcIA6AWMBQMElVT
# LVRFWEFTLTgwMzQ1NzQ2OIENaHFAbWltaWNjLmRldjANBgkqhkiG9w0BAQsFAAOC
# AYEAfPNXT52FWgoj58xYe4a6P/iKPAE6cWh0DL+u0JCHsn3DSh0m5dc1/BYfKOax
# 2u4mskehl51QqH5nYZbmJA6l2DXzFzChseS8noWws+hG+pfKRp7Wr7T4Ia5wE8BZ
# zgSxg1ajfYKZXrlZmgo+GP+PFgDUtmn66iMbQ22QWZH9QWDJVE9EOooG4F2rIunc
# dSOX1C6yvsw27OZXr0PaQjEZBBPMD4YYDBavYCZhFAc71hIAwm4z5EuYUmq41GyO
# Jy9/oFB5d5i6Iy1fI5lCufBrbuGy+h+eZ9ZCaf1MwP86RNreJSxMafo/0X1BVsDa
# ARZ7AFHYVwwMKHDoHqqJTGO5WZSGfeowz+kGcz6NEyH2k5NHatNQepMufCZU6tfv
# +PtefbmnGW6IffJsEcyecOw96UdRoyqMWMqsVc/d7EghawUzUKNsRyp6hvnmap2n
# jz5xXWRlCIE/Jav239TTaKPtshblRcWNS+NOYcVZaMyAquCUHMHFlIhYoVNdi160
# YRAvMYIDDTCCAwkCAQEwbDBXMQswCQYDVQQGEwJHQjEYMBYGA1UEChMPU2VjdGln
# byBMaW1pdGVkMS4wLAYDVQQDEyVTZWN0aWdvIFB1YmxpYyBDb2RlIFNpZ25pbmcg
# Q0EgRVYgUjM2AhEA5so1uUAO8feM8R1ccr4/kjAJBgUrDgMCGgUAoHgwGAYKKwYB
# BAGCNwIBDDEKMAigAoAAoQKAADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAc
# BgorBgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUBZg4
# w9WCp6ndp+1QQS++v9kR38AwDQYJKoZIhvcNAQEBBQAEggIAU39yjMVZCPL4/ncL
# Lm5uoTqRrH9ros794BZrq6/5tPW4Vc8HdpF/gOlw/XlBB9xE+voiZz5RDoj68ogd
# rz3vVe71ulO907iv+v2LgGD7d55I+qSgY50YNNq2PwNUOoAFhgk8URlPwUn5zZS+
# EFqtzF9OuB5Cnnls1igzF+5TX9x0ut2FQzOKt3c+sBjtUPlmT3/1aveLT2HGsOGI
# dqNVgPzy7WI7MLIuLi7OsVSO5HsaeoG5FIaQwJiM93fzOyN73Vrzf2lYS20b80/h
# EBuywp8n/5Jjml3leeR36NEw7/CPZ31/jUehVrxFirrSbMRF3WiwVOd1p3IwwopZ
# Wq/vSRUX80iUZRiqgV4AvBikky78/EQUzzgKLoVmOCZP3ZY8N/Uel50QXtLNmR0m
# 1czu28I30OEJpZZU53B0mnOr0LxjhB+xmCWyf3hJLDIr0ecP63/X1t4wBPRagTkx
# /a6A70uaOm8+lICx3GwtwX/Ef027wJJxuFrYV0j243mG+24TermaGsry9uogiDc6
# 89/D4MuMqOe/GTgVLZcaxXsJV4zZoUwKmuBIDhHeHNtqjazYJXPJZjZOC0djiVIH
# EMDunDuDq/BGs03XssyjrPQpWcVb4ZbExuiRtYeIUXIMGKCyyNLcT2mSCgDEVaUE
# KhuQMImLatt2CNXrmcUZBSzZT8o=
# SIG # End signature block
