#include "mock.h"
#include "mock_cfg.h"

/* For the array of 10 function pointers */
#define VARIADIC_RETURNS_INT(idx) \
int dummyFunc##idx(int inp, ...) \
{ \
    return idx; \
}

VARIADIC_RETURNS_INT(1)
VARIADIC_RETURNS_INT(2)
VARIADIC_RETURNS_INT(3)
VARIADIC_RETURNS_INT(4)
VARIADIC_RETURNS_INT(5)

int (*(dummyArray[5]))(int inp, ...) = {
    dummyFunc1,
    dummyFunc2,
    dummyFunc3,
    dummyFunc4,
    dummyFunc5
};

int main(int argc, char **argv)
{
    int i = 0;
    START_TEST;
    MOCK_FUNCTIONS(c89_function_pointers).arrayOfVariadics.expect("HEY", sizeof("HEY"));
    MOCK_FUNCTIONS(c89_function_pointers).arrayOfVariadics.andReturn(&dummyArray);

    int (*(*ret)[5])(int inp, ...) = arrayOfVariadics("HEY");

    for (i = 0; i < 5; i++) {
        int res = (*ret)[i](i);
        if (res != (i + 1)) {
            fprintf(stderr, "mismatch on %d, res = %d\n", i, res);
        }
    }

    struct outerOps outerOpsUut;
    MOCK_STRUCT(c89_function_pointers.outerOps).mockFunctionPointers(&outerOpsUut);


    
    char testRetBuf[] = "TEST";
    MOCK_VARIABLES(c89_function_pointers.innerOps).readfn.expect(10);
    MOCK_VARIABLES(c89_function_pointers.innerOps).readfn.andReturn(1, testRetBuf, strlen(testRetBuf) + 1);
    MOCK_VARIABLES(c89_function_pointers.innerOps).writefn.expect(NULL, 0, 20);
    MOCK_VARIABLES(c89_function_pointers.innerOps).writefn.andReturn(2);

    char retBuf[sizeof("TEST")];
    int readfnret = outerOpsUut.innerOps.readfn(retBuf, 10);
    if (readfnret != 1) {
        fprintf(stderr, "readfnret mismatch\n");
        exit(1);
    }

    if (strcmp(testRetBuf, retBuf) != 0) {
        fprintf(stderr, "pBuf mismatch, retBuf = %s\n", retBuf);
        exit(1);
    }
    int writefnret = outerOpsUut.innerOps.writefn(NULL, 20);
    if (writefnret != 2) {
        fprintf(stderr, "writefnret mismatch\n");
        exit(1);
    }

    END_TEST;
    confirmSuccessOrDie();

    return 0;
}
