#include "mock.h"
#include "mock_cfg.h"

#include "c89_returns.h"

float specialVal = 12345.0;
float *pSpecialVal = &specialVal;
float specialFunc(void) {
    return specialVal;
}
struct recordType specialStruct = {1, 2};

float generator1(void) {
    return specialVal;
}

float *generator2(void) {
    return pSpecialVal;
}

float (*generator3(void))(void) {
    return specialFunc;
}

struct recordType generator4(void)
{
    return specialStruct;
}

const struct recordType generator5(void)
{
    return specialStruct;
}

void testFloatReturn(void)
{
    float retVal = funcReturnsFloat();
    assert_eq_fatal(0, retVal);

    MOCK_FUNCTIONS(c89_returns).funcReturnsFloat.setReturnGenerator(generator1);
    retVal = funcReturnsFloat();
    assert_eq_fatal(specialVal, retVal);
}

void testFloatPtrReturn(void)
{
    float *retVal = funcReturnsPointerToFloat();
    assert_eq_fatal(NULL, retVal);

    MOCK_FUNCTIONS(c89_returns).funcReturnsPointerToFloat.setReturnGenerator(generator2);
    retVal = funcReturnsPointerToFloat();
    assert_eq_fatal(pSpecialVal, retVal);
}

void testFuncPtrReturn(void)
{
    float (*retVal)(void) = funcReturnsPtrToFuncReturningFloat();
    assert_eq_fatal(NULL, retVal);

    MOCK_FUNCTIONS(c89_returns).funcReturnsPtrToFuncReturningFloat.setReturnGenerator(generator3);
    retVal = funcReturnsPtrToFuncReturningFloat();
    assert_eq_fatal(specialVal, retVal());
}

void testRecordReturn(void)
{
    struct recordType retVal = funcReturnsRecord();
    assert_eq_fatal(0, retVal.field1);
    assert_eq_fatal(0, retVal.field2);

    MOCK_FUNCTIONS(c89_returns).funcReturnsRecord.setReturnGenerator(generator4);
    retVal = funcReturnsRecord();
    assert_eq_fatal(1, retVal.field1);
    assert_eq_fatal(2, retVal.field2);
}

void testConstRecordReturn(void)
{
    const struct recordType retVal1 = funcReturnsConstRecord();
    assert_eq_fatal(0, retVal1.field1);
    assert_eq_fatal(0, retVal1.field2);

    MOCK_FUNCTIONS(c89_returns).funcReturnsConstRecord.setReturnGenerator(generator5);
    const struct recordType retVal2 = funcReturnsConstRecord();
    assert_eq_fatal(1, retVal2.field1);
    assert_eq_fatal(2, retVal2.field2);
}

int main(int argc, char **argv)
{
    START_TEST;
    testFloatReturn();
    testFloatPtrReturn();
    testFuncPtrReturn();
    testRecordReturn();
    testConstRecordReturn();
    END_TEST;
    confirmSuccessOrDie();
    return 0;
}