#include <stdio.h>
#include "mock.h"
#include "mock_cfg.h"

int main(int argc, char **argv)
{
    volatile cvMethodTest uutVolatile;
    const cvMethodTest uutConst;
    const volatile cvMethodTest uutConstVolatile;
    const char *pArg;
    int ret = 0;

    auto constApi = MOCK_FUNCTIONS(cv_method.cvMethodTest).thisIsAMethod.resolve<
        int (cvMethodTest::*)(const char *) const
    >();
    auto volatileApi = MOCK_FUNCTIONS(cv_method.cvMethodTest).thisIsAMethod.resolve<
        int (cvMethodTest::*)(const char *) volatile
    >();
    auto constVolApi = MOCK_FUNCTIONS(cv_method.cvMethodTest).thisIsAMethod.resolve<
        int (cvMethodTest::*)(const char *) const volatile
    >();

    START_TEST;
    constApi.expect(&uutConst, "CONST", sizeof("CONST"));
    constApi.andReturn(2);
    ret = uutConst.thisIsAMethod("CONST");
    if (ret != 2) {
        fprintf(stderr, "returned %d, expected %d\n", ret, 2);
    }

    volatileApi.expect(&uutVolatile, "VOLATILE", sizeof("VOLATILE"));
    volatileApi.andReturn(1);
    ret = uutVolatile.thisIsAMethod("VOLATILE");
    if (ret != 1) {
        fprintf(stderr, "returned %d, expected %d\n", ret, 1);
    }

    constVolApi.expect(&uutConstVolatile, "CONST VOLATILE", sizeof("CONST VOLATILE"));
    constVolApi.andReturn(2);
    ret = uutConstVolatile.thisIsAMethod("CONST VOLATILE");
    if (ret != 2) {
        fprintf(stderr, "returned %d, expected %d\n", ret, 2);
    }

    END_TEST;
    confirmSuccessOrDie();

    return 0;
}
