#include "mock_cfg.h"
#include "mock.h"

#include "record_assign.hpp"


int copySupport2::s_idx = 0;
int copySupport2::s_val[32] = {0};

void testDoStuff1Const(void)
{
    
    
    START_TEST;
    recordCopyAssign uut;
    copySupport1 retArg1;
    copySupport1 retArg2;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff1Const.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff1Const.andReturn(retArg1, retArg2);
    copySupport1 testArg1;
    copySupport1 testArg2;
    uut.doStuff1Const(testArg1, testArg2);
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    recordCopyAssign uut;
    copySupport1 retArg1;
    copySupport1 retArg2;
    static bool arg1Called = false;
    static bool arg2Called = false;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff1Const.setAssign(
        [ ](const copySupport1 &lhs, const copySupport1 &rhs) {
            arg1Called = true;
        },
        [ ](const copySupport1 &lhs, const copySupport1 &rhs) {
            arg2Called = true;
        }
    );
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff1Const.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff1Const.andReturn(retArg1, retArg2);
    copySupport1 testArg1;
    copySupport1 testArg2;
    uut.doStuff1Const(testArg1, testArg2);
    assert_eq_fatal(true, arg1Called);
    assert_eq_fatal(true, arg2Called);
    END_TEST;
    confirmSuccessOrDie();
}

void testDoStuff1NonConst(void)
{
    
    
    START_TEST;
    recordCopyAssign uut;
    copySupport1 retArg1;
    copySupport1 retArg2;
    retArg1.m_val = 1;
    retArg2.m_val = 2;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff1NonConst.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff1NonConst.andReturn(retArg1, retArg2);
    copySupport1 testArg1;
    copySupport1 testArg2;
    uut.doStuff1NonConst(testArg1, testArg2);
    assert_eq_fatal(1, testArg1.m_val);
    assert_eq_fatal(2, testArg2.m_val);
    END_TEST;
    confirmSuccessOrDie();

}

void testDoStuff2Const(void)
{
    
    START_TEST;
    recordCopyAssign uut;
    copySupport2 retArg1;
    copySupport2 retArg2;
    retArg1.m_val = 1;
    retArg2.m_val = 2;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff2Const.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff2Const.andReturn(retArg1, retArg2);
    copySupport2 testArg1;
    copySupport2 testArg2;
    uut.doStuff2Const(testArg1, testArg2);
    assert_eq_fatal(2, copySupport2::s_idx);
    assert_eq_fatal(1, copySupport2::s_val[0]);
    assert_eq_fatal(2, copySupport2::s_val[1]);
    END_TEST;
    confirmSuccessOrDie();
    copySupport2::s_idx = 0;
}

void testDoStuff2NonConst(void)
{
    
    
    
    
    START_TEST;
    recordCopyAssign uut;
    copySupport2 retArg1;
    copySupport2 retArg2;
    retArg1.m_val = 1;
    retArg2.m_val = 2;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff2NonConst.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff2NonConst.andReturn(retArg1, retArg2);
    copySupport2 testArg1;
    copySupport2 testArg2;
    uut.doStuff2NonConst(testArg1, testArg2);
    assert_eq_fatal(2, copySupport2::s_idx);
    assert_eq_fatal(1, copySupport2::s_val[0]);
    assert_eq_fatal(2, copySupport2::s_val[1]);
    END_TEST;
    confirmSuccessOrDie();
    copySupport2::s_idx = 0;
}

void testDoStuff3Const(void)
{
    
    
    
    
    START_TEST;
    recordCopyAssign uut;
    copySupport3 retArg1;
    copySupport3 retArg2;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff3Const.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff3Const.andReturn(retArg1, retArg2);
    copySupport3 testArg1;
    copySupport3 testArg2;
    uut.doStuff3Const(testArg1, testArg2);
    END_TEST;
    confirmFailureOrDie();


    START_TEST;
    recordCopyAssign uut;
    copySupport3 retArg1;
    copySupport3 retArg2;
    static bool arg1Called = false;
    static bool arg2Called = false;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff3Const.setAssign(
        [ ](const copySupport3 &lhs, const copySupport3 &rhs) {
            arg1Called = true;
        },
        [ ](const copySupport3 &lhs, const copySupport3 &rhs) {
            arg2Called = true;
        }
    );
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff3Const.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff3Const.andReturn(retArg1, retArg2);
    copySupport3 testArg1;
    copySupport3 testArg2;
    uut.doStuff3Const(testArg1, testArg2);
    END_TEST;
    confirmSuccessOrDie();
}

void testDoStuff3NonConst(void)
{
    
    
    
    START_TEST;
    recordCopyAssign uut;
    copySupport3 retArg1;
    retArg1.m_val = 1;
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff3NonConst.expect(&uut);
    MOCK_FUNCTIONS(record_assign.recordCopyAssign).doStuff3NonConst.andReturn(retArg1);
    copySupport3 testArg1;
    uut.doStuff3NonConst(testArg1);
    
    assert_eq_fatal(1, testArg1.m_val);
    assert_eq_fatal(0x1234, retArg1.m_val);
    END_TEST;
    confirmFailureOrDie();
}

int main(int argc, char **argv)
{
    MOCK_FILE(record_assign).reset();
    testDoStuff1Const();
    MOCK_FILE(record_assign).reset();
    testDoStuff1NonConst();
    MOCK_FILE(record_assign).reset();
    testDoStuff2Const();
    MOCK_FILE(record_assign).reset();
    testDoStuff2NonConst();
    MOCK_FILE(record_assign).reset();
    testDoStuff3Const();
    return 0;
}