#include "mock_cfg.h"
#include "mock.h"

#include "record_cmp.hpp"

bool support1MockCmp(const support1 &arg1, const support1 &arg2)
{
    return arg1.m_val == arg2.m_val;
}

int main(int argc, char **argv)
{
    support1 s1test1, s1test2;
    support2 s2test1, s2test2;
    support3 s3test1, s3test2;
    recordCmp uut;

    START_TEST;
    
    
    MOCK_FUNCTIONS(record_cmp.recordCmp).doStuff1Const.expect(&uut, s1test1, s1test2);
    uut.doStuff1Const(s1test1, s1test2);
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    
    MOCK_STRUCT(record_cmp.recordCmp).reset();
    s1test1.m_val = 123;
    s1test2.m_val = 123;
    MOCK_FUNCTIONS(record_cmp.recordCmp).doStuff1Const.expect(&uut, s1test1, s1test2);
    MOCK_FUNCTIONS(record_cmp.recordCmp).doStuff1Const.setCompare(NULL, support1MockCmp, support1MockCmp);
    uut.doStuff1Const(s1test1, s1test2);
    END_TEST;
    confirmSuccessOrDie();

    START_TEST;
    
    
    MOCK_FUNCTIONS(record_cmp.recordCmp).doStuff1NonConst.expect(&uut, s1test1, s1test2);
    uut.doStuff1NonConst(s1test1, s1test2);
    END_TEST;
    confirmSuccessOrDie();

    START_TEST;
    
    
    s2test1.m_val = 345;
    s2test2.m_val = 345;
    MOCK_FUNCTIONS(record_cmp.recordCmp).doStuff2Const.expect(&uut, s2test1, s2test2);
    uut.doStuff2Const(s2test1, s2test2);
    END_TEST;
    confirmSuccessOrDie();


    START_TEST;
    
    
    s3test1.m_val = 678;
    s3test2.m_val = 678;
    MOCK_FUNCTIONS(record_cmp.recordCmp).doStuff3Const.expect(&uut, s3test1, s3test2);
    uut.doStuff3Const(s3test1, s3test2);
    END_TEST;
    confirmSuccessOrDie();

    return 0;
}