#include <stdio.h>
#include <string.h>

#include "mock_cfg.h"
#include "mock.h"

int main(int argc, char **argv)
{
    returnByArg uut;
    int inp1 = 0;
    float EXPECTED_RET1 = 1.0;
    float EXPECTED_RET2 = 2.0;
    float actualReturn = 0;

    START_TEST;
    MOCK_STRUCT(return_by_arg.returnByArg).setCompare([](const returnByArg *, const returnByArg *) {
        return true;
    });

    
    MOCK_FUNCTIONS(return_by_arg.returnByArg).ptrOrRefReturn.resolve<void (returnByArg::*)(const int, float *)>().expect(&uut, inp1, &actualReturn, 1);
    MOCK_FUNCTIONS(return_by_arg.returnByArg).ptrOrRefReturn.resolve<void (returnByArg::*)(const int, float *)>().andReturn(&EXPECTED_RET1, 1);
    uut.ptrOrRefReturn(inp1, &actualReturn);
    if (actualReturn != EXPECTED_RET1) {
        fprintf(stderr, "return by pointer failed, expected = %f, actual = %f\n", EXPECTED_RET1, actualReturn);
        return -1;
    }

    
    MOCK_FUNCTIONS(return_by_arg.returnByArg).ptrOrRefReturn.resolve<void (returnByArg::*)(const int, float &)>().expect(&uut, inp1, actualReturn);
    MOCK_FUNCTIONS(return_by_arg.returnByArg).ptrOrRefReturn.resolve<void (returnByArg::*)(const int, float &)>().andReturn(EXPECTED_RET2);
    uut.ptrOrRefReturn(inp1, actualReturn);
    if (actualReturn != EXPECTED_RET2) {
        fprintf(stderr, "return by ref failed\n");
        return -1;
    }

    
    float arrayRetIn[10] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    float arrayRetOut[10] = {11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    MOCK_FUNCTIONS(return_by_arg.returnByArg).arrayRet.expect(&uut);
    MOCK_FUNCTIONS(return_by_arg.returnByArg).arrayRet.andReturn("FIXED RET", arrayRetOut);
    const char *testOut = uut.arrayRet(arrayRetIn);
    for (int i = 0; i < 10; i++) {
        if (arrayRetIn[i] != arrayRetOut[i]) {
            printf("%f, %f\n", arrayRetIn[i], arrayRetOut[i]);
            fprintf(stderr, "return by ref failed on index %d\n", i);
            return -1;
        }
    }
    END_TEST;
    confirmSuccessOrDie();

    
    
    float retIn = 1.0;
    float retOut = 2.0;
    struct returnByArg::memDescriptor inp {&retIn, sizeof(float)};
    struct returnByArg::memDescriptor outp {&retOut, sizeof(float)};

    START_TEST;
    MOCK_STRUCT(return_by_arg.returnByArg.memDescriptor).setCompare(
        [](const returnByArg::memDescriptor *dst, const returnByArg::memDescriptor *src) {
            return true;
        }
    );
    MOCK_FUNCTIONS(return_by_arg.returnByArg).returnBySmartPointer.expect(&uut);
    MOCK_FUNCTIONS(return_by_arg.returnByArg).returnBySmartPointer.andReturn(outp);
    uut.returnBySmartPointer(inp);
    END_TEST;
    
    confirmFailureOrDie();

    
    START_TEST;
    MOCK_FUNCTIONS(return_by_arg.returnByArg).returnBySmartPointer.reset();
    MOCK_STRUCT(return_by_arg.returnByArg.memDescriptor).setAssign(
        [](returnByArg::memDescriptor *dst, returnByArg::memDescriptor *src) {
            memcpy(dst->pValue, src->pValue, src->size);
        }
    );
    MOCK_FUNCTIONS(return_by_arg.returnByArg).returnBySmartPointer.expect(&uut);
    MOCK_FUNCTIONS(return_by_arg.returnByArg).returnBySmartPointer.andReturn(outp);
    uut.returnBySmartPointer(inp);


    if (*(float*)inp.pValue != retOut) {
        fprintf(stderr, "output copy seems to have failed. Expected %f, got %f\n", retOut, *(float*)inp.pValue);
        exit(1);
    }

    END_TEST;
    confirmSuccessOrDie();

    return 0;
}
