#include <stdio.h>
#include <string.h>

#include <memory>

#include "mock_cfg.h"
#include "mock.h"

int main(int argc, char **argv)
{
    
    
    MOCK_STRUCT(returns.returnsTest).setCompare(
        [](const returnsTest *lhs, const returnsTest *rhs) { return true; }
    );

    
    START_TEST
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsVectOfUnique.expect(NULL);

    std::vector<std::unique_ptr<int>> uglyIn, uglyOut;

    uglyIn.push_back(std::make_unique<int>(1));
    uglyIn.push_back(std::make_unique<int>(2));
    uglyIn.push_back(std::make_unique<int>(3));
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsVectOfUnique.expect(NULL);
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsVectOfUnique.andReturn(std::move(uglyIn));

    returnsTest uut;
    uglyOut = uut.funcReturnsVectOfUnique();

    assert_eq_fatal(1, *uglyOut[0]);
    assert_eq_fatal(2, *uglyOut[1]);
    assert_eq_fatal(3, *uglyOut[2]);

    END_TEST
    confirmSuccessOrDie();

    
    START_TEST
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsPOD.expect(NULL);
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsPOD.andReturn((returnsTest::podType){1.1f, 2});

    returnsTest uut;
    returnsTest::podType out = uut.funcReturnsPOD();
    assert_eq_fatal(1.1f, out.field1);
    assert_eq_fatal(2, out.field2);
    END_TEST
    confirmSuccessOrDie();

    
    START_TEST
    returnsTest::nonPODType in;
    in.field1 = 1.1f;
    in.field2 = 2;
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsNonPOD.expect(NULL);
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsNonPOD.andReturn(in);

    returnsTest uut;
    returnsTest::nonPODType out = uut.funcReturnsNonPOD();
    assert_eq_fatal(1.1f, out.field1);
    assert_eq_fatal(2, out.field2);
    END_TEST
    confirmSuccessOrDie();

    
    START_TEST
    returnsTest::noConstructType in("TEST1");
    in.field1 = 1.1f;
    in.field2 = 2;
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsNoConstructType.expect(NULL);
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsNoConstructType.andReturn(in);

    returnsTest uut;
    returnsTest::noConstructType out = uut.funcReturnsNoConstructType();
    assert_eq_fatal(1.1f, out.field1);
    assert_eq_fatal(2, out.field2);
    assert_eq_fatal(0, strcmp("TEST1", out.name));
    END_TEST
    confirmSuccessOrDie();

    
    START_TEST
    returnsTest::noConstructType in("TEST2");
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsRValRefToNoConstructType.expect(NULL);
    MOCK_FUNCTIONS(returns.returnsTest).funcReturnsRValRefToNoConstructType.andReturn(
        std::move(in)
    );

    returnsTest uut;
    assert_eq_fatal(0, strcmp("TEST2", uut.funcReturnsRValRefToNoConstructType().name));
    END_TEST
    confirmSuccessOrDie();

    return 0;
}