#include "mock.h"
#include "mock_cfg.h"

int main(int argc, char **argv)
{
    START_TEST;
    auto *constrNode = &MOCK_CONSTRUCTOR(singleton.SingletonTest).resolve<void (SingletonTest::*)(void)>();
    SingletonTest *inst = constrNode->makeInstance();

    MOCK_FUNCTIONS(singleton.SingletonTest).instance.expect();
    MOCK_FUNCTIONS(singleton.SingletonTest).instance.andReturn(*inst);

    SingletonTest &inst_check = SingletonTest::instance();
    if (&inst_check != inst) {
        fprintf(stderr, "WE HAVE A PROBLEM");
    }
    MOCK_FUNCTIONS(singleton.SingletonTest).finalize.expect(inst);
    inst_check.finalize();

    MOCK_FILE(singleton).reset();

    constrNode->makeInstance();
    MOCK_FUNCTIONS(singleton.SingletonTest).instance.expect();
    MOCK_FUNCTIONS(singleton.SingletonTest).instance.andReturn(*inst);
    SingletonTest &inst_check2 = SingletonTest::instance();
    if (&inst_check2 != inst) {
        fprintf(stderr, "WE HAVE A PROBLEM");
    }
    END_TEST;
    confirmSuccessOrDie();

    return 0;
}
