#include <stdio.h>
#include <stdbool.h>
#include "mock.h"
#include "mock_cfg.h"

int func1_hook1(const char *pArg, va_list args)
{
    return 123;
}

int func1_hook2(const char *pArg, va_list args)
{
    return MOCK_FUNCTIONS(c89_hook).func1.shadowCall(pArg, args);
}

int g_func2Hook1Called = 0;
void func2_hook1(const coords_t *pCoords, const int numCoords)
{
    g_func2Hook1Called++;
}

void func2_hook2(const coords_t *pCoords, const int numCoords)
{
    MOCK_FUNCTIONS(c89_hook).func2.shadowCall(pCoords, numCoords);
}

int g_func3Hook1Called = 0;
void func3_hook1(coords_t *pRetCoords, const int numCoords)
{
    g_func3Hook1Called++;
}

void func3_hook2(coords_t *pRetCoords, const int numCoords)
{
    MOCK_FUNCTIONS(c89_hook).func3.shadowCall(pRetCoords, numCoords);
    /* overwrite the coordinates to make sure it has priority */
    pRetCoords[0].x = 0.1f;
    pRetCoords[0].y = 0.2f;
}

void test_func1(void)
{
    int res = 0;
    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func1.setHook(func1_hook1);
    res = func1("TEST");
    assert_eq_fatal(res, 123);

    MOCK_FUNCTIONS(c89_hook).func1.reset();
    res = func1("TEST");
    assert_eq_fatal(res, 0);

    MOCK_FUNCTIONS(c89_hook).func1.setHook(func1_hook2);
    res = func1("TEST");
    END_TEST;
    confirmSuccessOrDie();
    assert_eq_fatal(res, 0);

    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func1.expect("TEST", sizeof("TEST"));
    MOCK_FUNCTIONS(c89_hook).func1.andReturn(345);
    res = func1("FAIL");
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func1.reset();
    MOCK_FUNCTIONS(c89_hook).func1.setHook(func1_hook2);
    MOCK_FUNCTIONS(c89_hook).func1.expect("TEST", sizeof("TEST"));
    MOCK_FUNCTIONS(c89_hook).func1.andReturn(345);
    res = func1("TEST");
    END_TEST;
    confirmSuccessOrDie();
    assert_eq_fatal(res, 345);
}

void coordAssign(coords_t *pLHS, coords_t *pRHS, const size_t count)
{
    size_t i = 0;
    for (i = 0; i < count; i++) {
        pLHS[i].x = pRHS[i].x;
        pLHS[i].y = pRHS[i].y;
    }
}

bool coordCheck(coords_t *pLHS, coords_t *pRHS, const size_t count)
{
    bool res = true;
    size_t i = 0;
    for (i = 0; i < count; i++) {
        res = res && (pLHS[i].x == pRHS[i].x) && (pLHS[i].y == pRHS[i].y);
    }
    return res;
}

void test_func2(void)
{
    const coords_t testCoords[] = {
        {1, 2},
        {3, 4},
        {5, 6}
    };
    const int NUM_COORDS = sizeof(testCoords) / sizeof(testCoords[0]);

    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func2.setHook(func2_hook1);
    MOCK_FUNCTIONS(c89_hook).func2.expect(testCoords, NUM_COORDS, NUM_COORDS);
    func2(testCoords, NUM_COORDS);
    assert_eq_fatal(g_func2Hook1Called, 1);

    MOCK_FUNCTIONS(c89_hook).func2.reset();
    MOCK_FUNCTIONS(c89_hook).func2.expect(testCoords, NUM_COORDS, NUM_COORDS);
    
    func2(testCoords, NUM_COORDS);
    assert_eq_fatal(g_func2Hook1Called, 1);

    /* moving on to hook 2, which will call the shadow function */
    MOCK_FUNCTIONS(c89_hook).func2.reset();
    MOCK_FUNCTIONS(c89_hook).func2.setHook(func2_hook2);
    func2(testCoords, NUM_COORDS);
    END_TEST;
    confirmSuccessOrDie();
    assert_eq_fatal(g_func2Hook1Called, 1);


    const coords_t badTestCoords[] = {
        {1, 2},
        {3, 4},
        {5, 7}
    };

    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func3.setCompare(coordCheck, NULL);
    MOCK_FUNCTIONS(c89_hook).func2.expect(testCoords, NUM_COORDS, NUM_COORDS);
    func2(badTestCoords, NUM_COORDS);
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func2.reset();
    MOCK_FUNCTIONS(c89_hook).func2.setHook(func2_hook2);
    
    MOCK_FUNCTIONS(c89_hook).func2.expect(testCoords, NUM_COORDS, NUM_COORDS);
    func2(testCoords, NUM_COORDS);
    END_TEST;
    confirmSuccessOrDie();
}

void test_func3(void)
{
    coords_t testCoordsIn[] = {
        {1, 2},
        {3, 4},
        {5, 6}
    };
    coords_t testCoordsOut1[] = {
        {10, 20},
        {30, 40},
        {50, 60}
    };
    coords_t testCoordsOut2[] = {
        {100, 200},
        {300, 400},
        {500, 600}
    };
    const int NUM_COORDS = sizeof(testCoordsIn) / sizeof(testCoordsIn[0]);

    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func3.setHook(func3_hook1);
    MOCK_FUNCTIONS(c89_hook).func3.expect(testCoordsIn, NUM_COORDS, NUM_COORDS);
    MOCK_FUNCTIONS(c89_hook).func3.andReturn(testCoordsOut1, NUM_COORDS);
    func3(testCoordsIn, NUM_COORDS);
    assert_eq_fatal(g_func3Hook1Called, 1);
    
    assert_eq_fatal(testCoordsIn[2].x, 5.0f);

    MOCK_FUNCTIONS(c89_hook).func3.reset();
    
    MOCK_FUNCTIONS(c89_hook).func3.expect(testCoordsIn, NUM_COORDS, NUM_COORDS);
    MOCK_FUNCTIONS(c89_hook).func3.setAssign(coordAssign);
    MOCK_FUNCTIONS(c89_hook).func3.andReturn(testCoordsOut1, NUM_COORDS);
    func3(testCoordsIn, NUM_COORDS);
    assert_eq_fatal(g_func3Hook1Called, 1);
    
    assert_eq_fatal(testCoordsIn[2].x, 50.0f);

    /* moving on to hook 2, which will call the shadow function */
    MOCK_FUNCTIONS(c89_hook).func3.reset();
    MOCK_FUNCTIONS(c89_hook).func3.setHook(func3_hook2);
    MOCK_FUNCTIONS(c89_hook).func3.expect(testCoordsIn, NUM_COORDS, NUM_COORDS);
    MOCK_FUNCTIONS(c89_hook).func3.setAssign(coordAssign);
    MOCK_FUNCTIONS(c89_hook).func3.andReturn(testCoordsOut2, NUM_COORDS);
    func3(testCoordsIn, NUM_COORDS);

    assert_eq_fatal(g_func3Hook1Called, 1);
    
    assert_eq_fatal(testCoordsIn[2].x, 500.0f);
    
    assert_eq_fatal(testCoordsIn[0].x, 0.1f);

    END_TEST;
    confirmSuccessOrDie();

    coords_t badTestCoords[] = {
        {100, 200},
        {300, 400},
        {500, 700}
    };

    START_TEST;
    MOCK_FUNCTIONS(c89_hook).func3.reset();
    MOCK_FUNCTIONS(c89_hook).func3.setHook(func3_hook2);
    MOCK_FUNCTIONS(c89_hook).func3.setCompare(coordCheck, NULL);
    MOCK_FUNCTIONS(c89_hook).func3.expect(testCoordsIn, NUM_COORDS, NUM_COORDS);
    func3(badTestCoords, NUM_COORDS);
    END_TEST;
    confirmFailureOrDie();
}

int main(int argc, char **argv)
{
    test_func1();
    test_func2();
    test_func3();
    return 0;
}
