#include "mock.h"
#include "mock_cfg.h"

#include "c89_inputs.h"

void testFloatInput(void)
{
    START_TEST;
    float inp = 1234;
    MOCK_FUNCTIONS(c89_inputs).funcTakesFloat.expect(inp);
    funcTakesFloat(inp);
    END_TEST;
    confirmSuccessOrDie();
}

void testPointerToFloatInput(void)
{
    float inp1 = 1234;
    float inp2 = 1234;

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToFloat.expect(&inp1, 0);
    funcTakesPointerToFloat(&inp1);
    END_TEST;
    confirmSuccessOrDie();

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToFloat.expect(&inp1, 1);
    funcTakesPointerToFloat(&inp1);
    END_TEST;
    confirmSuccessOrDie();

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToFloat.expect(&inp1, 0);
    funcTakesPointerToFloat(&inp2);
    END_TEST;
    confirmFailureOrDie();

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToFloat.expect(&inp1, 1);
    funcTakesPointerToFloat(&inp2);
    END_TEST;
    confirmSuccessOrDie();
}

void testPointerToPointerInput(void)
{
    float val1 = 1234;
    float *inp1 = &val1;
    float val2 = 1234;
    float *inp2 = &val2;

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToPointer.expect(&inp1, 0);
    funcTakesPointerToPointer(&inp1);
    END_TEST;
    confirmSuccessOrDie();

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToPointer.expect(&inp1, 1);
    funcTakesPointerToPointer(&inp2);
    END_TEST;
    confirmFailureOrDie();

    
    START_TEST;
    inp2 = &val1;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToPointer.expect(&inp1, 1);
    funcTakesPointerToPointer(&inp2);
    END_TEST;
    confirmSuccessOrDie();
}

void testConstantArrayOfFloatInput(void)
{
    float expInp[5] = {1, 2, 3, 4, 5};
    float actInp[5] = {1, 2, 3, 4, 5};
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesConstantArrayOfFloat.expect(expInp);
    funcTakesConstantArrayOfFloat(actInp);
    END_TEST;
    confirmSuccessOrDie();

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesConstantArrayOfFloat.expect(expInp);
    actInp[4] = 0;
    funcTakesConstantArrayOfFloat(actInp);
    END_TEST;
    confirmFailureOrDie();
}

void testVariableArrayOfFloatInput(void)
{
    
    float expInp[] = {1, 2, 3, 4, 5};
    float actInp[] = {1, 2, 3, 4, 5};
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesVariableArrayOfFloat.expect(expInp, 5);
    funcTakesVariableArrayOfFloat(actInp);
    END_TEST;
    confirmSuccessOrDie();

    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesVariableArrayOfFloat.expect(expInp, 5);
    actInp[4] = 0;
    funcTakesVariableArrayOfFloat(actInp);
    END_TEST;
    confirmFailureOrDie();
}

void fptr_test(float val)
{
    printf("val = %f\n", val);
}

void testFunctionPointerInput(void)
{
    
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPtrToFuncTakingFloat.expect(fptr_test);
    funcTakesPtrToFuncTakingFloat(fptr_test);
    END_TEST;
    confirmSuccessOrDie();

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPtrToFuncTakingFloat.expect(NULL);
    funcTakesPtrToFuncTakingFloat(fptr_test);
    END_TEST;
    confirmFailureOrDie();
}

bool compareRecordType(const struct recordType *arg1, const struct recordType *arg2)
{
    if (arg1->field1 == arg2->field1 && arg1->field2 == arg2->field2) {
        return 1;
    }
    return 0;
}

void testRecordInput(void)
{
    struct recordType inp = {1, 2};

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesRecord.expect(inp);
    /* no comparison operator, should fail: */
    funcTakesRecord(inp);
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesRecord.expect(inp);
    /* with comparison, succeeds: */
    MOCK_STRUCT(c89_inputs.recordType).setCompare(compareRecordType);
    funcTakesRecord(inp);
    END_TEST;
    confirmSuccessOrDie();
}

void testPointerToRecordInput(void)
{
    struct recordType expInp = {1, 2};
    struct recordType actInp = {1, 2};

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToRecord.expect(&expInp, 1);
    /* no comparison operator, should fail: */
    funcTakesPointerToRecord(&actInp);
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToRecord.expect(&expInp, 1);
    /* with comparison, succeeds: */
    MOCK_STRUCT(c89_inputs.recordType).setCompare(compareRecordType);
    funcTakesPointerToRecord(&actInp);
    END_TEST;
    confirmSuccessOrDie();

    /* change one of the fields, should fail */
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToRecord.expect(&expInp, 1);
    actInp.field2 = 0;
    funcTakesPointerToRecord(&actInp);
    END_TEST;
    confirmFailureOrDie();
}

void testConstRecordInput(void)
{
    const struct recordType inp = {1, 2};

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesConstRecord.expect(inp);
    /* no comparison operator, should fail: */
    funcTakesConstRecord(inp);
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesConstRecord.expect(inp);
    /* with comparison, succeeds: */
    MOCK_STRUCT(c89_inputs.recordType).setCompare(compareRecordType);
    funcTakesConstRecord(inp);
    END_TEST;
    confirmSuccessOrDie();
}

void testPointerToConstRecordInput(void)
{
    const struct recordType expInp = {1, 2};
    const struct recordType actInp = {1, 2};
    const struct recordType actInpBad = {1, 0};

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToConstRecord.expect(&expInp, 1);
    /* no comparison operator, should fail: */
    funcTakesPointerToConstRecord(&actInp);
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToConstRecord.expect(&expInp, 1);
    /* with comparison, succeeds: */
    MOCK_STRUCT(c89_inputs.recordType).setCompare(compareRecordType);
    funcTakesPointerToConstRecord(&actInp);
    END_TEST;
    confirmSuccessOrDie();

    /* change one of the fields, should fail */
    START_TEST;
    MOCK_FUNCTIONS(c89_inputs).funcTakesPointerToConstRecord.expect(&expInp, 1);
    funcTakesPointerToConstRecord(&actInpBad);
    END_TEST;
    confirmFailureOrDie();
}

int main(int argc, char **argv)
{
    MOCK_FILE(c89_inputs).reset();
    testFloatInput();
    MOCK_FILE(c89_inputs).reset();
    testPointerToFloatInput();
    MOCK_FILE(c89_inputs).reset();
    testPointerToPointerInput();
    MOCK_FILE(c89_inputs).reset();
    testConstantArrayOfFloatInput();
    MOCK_FILE(c89_inputs).reset();
    testVariableArrayOfFloatInput();
    MOCK_FILE(c89_inputs).reset();
    testFunctionPointerInput();
    MOCK_FILE(c89_inputs).reset();
    testRecordInput();
    MOCK_FILE(c89_inputs).reset();
    testPointerToRecordInput();
    MOCK_FILE(c89_inputs).reset();
    testConstRecordInput();
    MOCK_FILE(c89_inputs).reset();
    testPointerToConstRecordInput();
    return 0;
}
