#include <stdio.h>
#include <string.h>

#include "mock_cfg.h"
#include "mock.h"

int main(int argc, char **argv)
{
    testClass uut;

    auto testNode = &MOCK_CLASS(external_struct.testClass);
    testNode->mockFunctionPointers(&uut);
    
    START_TEST;
    testNode->variables.m_ext.fptr.expect(1, 2);
    uut.m_ext.fptr(1, 2);
    testNode->reset();
    
    uut.m_ext.fptr(2, 3);
    uut.m_ext.fptr(4, 5);
    END_TEST;
    confirmSuccessOrDie();

    START_TEST;
    testNode->variables.m_ext.fptr.expect(1, 2);
    uut.m_ext.fptr(4, 5);
    END_TEST;
    confirmFailureOrDie();

    return 0;
}
