#include "mock.h"
#include "mock_cfg.h"

/* For the array of 10 function pointers */
#define VARIADIC_RETURNS_INT(idx) \
int dummyFunc##idx(int inp, ...) \
{ \
    return idx; \
}

VARIADIC_RETURNS_INT(1)
VARIADIC_RETURNS_INT(2)
VARIADIC_RETURNS_INT(3)
VARIADIC_RETURNS_INT(4)
VARIADIC_RETURNS_INT(5)

int (*(dummyArray[5]))(int inp, ...) = {
    dummyFunc1,
    dummyFunc2,
    dummyFunc3,
    dummyFunc4,
    dummyFunc5
};

void testcb(int arg)
{
    printf("testcb, arg = %d\n", arg);
}


int testFunction(int arg, functionPointerTest::globalread_t cb)
{
    char buf[20];
    int res = -1;
    if (arg == 1) {
        int cbRes = cb(buf, sizeof(buf));
        if (strcmp(buf, "YES") == 0) {
            res = cbRes;
        }
    }
    return res;
}

int main(int argc, char **argv)
{
    functionPointerTest uut;

    START_TEST;
    MOCK_FUNCTIONS(function_pointers.functionPointerTest).
        arrayOfVariadics.expect(&uut, "HEY", sizeof("HEY"));
    MOCK_FUNCTIONS(function_pointers.functionPointerTest).
        arrayOfVariadics.andReturn(&dummyArray);

    int (*(*ret)[5])(int inp, ...) = uut.arrayOfVariadics("HEY");

    for (int i = 0; i < 5; i++) {
        int res = (*ret)[i](i);
        if (res != (i + 1)) {
            fprintf(stderr, "mismatch on %d, res = %d\n", i, res);
            exit(1);
        }
    }

    MOCK_STRUCT(function_pointers.functionPointerTest).mockFunctionPointers(&uut);
    MOCK_FUNCTIONS(function_pointers.functionPointerTest).
        thisFunctionReturnsAFunction.expect(&uut);
    MOCK_FUNCTIONS(function_pointers.functionPointerTest).
        thisFunctionReturnsAFunction.andReturn(testcb);

    void (*cbret)(int) = uut.thisFunctionReturnsAFunction();
    if (cbret != testcb) {
        fprintf(stderr, "function returned unexpected callback pointer\n");
        exit(1);
    }
    cbret(5);

    struct outerOps outerOpsUut;
    MOCK_STRUCT(function_pointers.outerOps).mockFunctionPointers(&outerOpsUut);
    MOCK_VARIABLES(function_pointers.outerOps.innerOps).readfn.expect(NULL, 0, 10);
    MOCK_VARIABLES(function_pointers.outerOps.innerOps).readfn.andReturn(1);
    MOCK_VARIABLES(function_pointers.outerOps.innerOps).writefn.expect(NULL, 0, 20);
    MOCK_VARIABLES(function_pointers.outerOps.innerOps).writefn.andReturn(2);
    int readfnret = outerOpsUut.innerOps.readfn(NULL, 10);
    if (readfnret != 1) {
        fprintf(stderr, "readfnret mismatch\n");
        exit(1);
    }
    int writefnret = outerOpsUut.innerOps.writefn(NULL, 20);
    if (writefnret != 2) {
        fprintf(stderr, "writefnret mismatch\n");
        exit(1);
    }

    
    char pStr[8] = "TEST";
    auto testNode = &MOCK_STRUCT(function_pointers.functionPointerTest);
    
    testNode->variables.thisIsAPOD.readfn.expect(pStr, sizeof("TEST"), sizeof("TEST"));
    testNode->variables.thisIsAPOD.readfn.andReturn(123);

    testNode->mockFunctionPointers(&uut);
    int testRes = uut.thisIsAPOD.readfn(pStr, sizeof("TEST"));
    if (testRes != 123) {
        fprintf(stderr, "Something went wrong\n");
    }

    
    testNode->reset();
    testRes = uut.thisIsAPOD.readfn(pStr, sizeof("TEST"));
    if (testRes != 0) {
        fprintf(stderr, "Something went wrong\n");
        exit(1);
    }

    MOCK_FUNCTIONS(function_pointers.functionPointerTest).globalread_t.expect(20);
    char cbBuf[] = "YES";
    MOCK_FUNCTIONS(function_pointers.functionPointerTest).globalread_t.andReturn(123, cbBuf, sizeof(cbBuf));
    int cbRes = testFunction(1, MOCK_FUNCTIONS(function_pointers.functionPointerTest).globalread_t.getImplementation());
    if (cbRes != 123) {
        fprintf(stderr, "unexpected result, expected = %d, actual = %d\n", 123, cbRes);
        exit(1);
    }

    END_TEST;
    confirmSuccessOrDie();
    return 0;
}
