#include <stdio.h>
#include <string.h>

#include "mock_cfg.h"
#include "mock.h"

int main(int argc, char **argv)
{
    inputsTest uut;
    std::vector<inputsTest> inputsTestVect;
    std::list<inputsTest> inputsTestList;

    
    START_TEST;
    MOCK_FUNCTIONS(inputs.inputsTest).funcTakesVectorOfInputs1.expect(&uut, inputsTestVect);
    uut.funcTakesVectorOfInputs1(inputsTestVect);
    END_TEST;
    confirmFailureOrDie();
    MOCK_FILE(inputs).reset();

    
    START_TEST;
    MOCK_FUNCTIONS(inputs.inputsTest).funcTakesVectorOfInputs2.expect(&uut, inputsTestVect);
    uut.funcTakesVectorOfInputs2(inputsTestVect);
    END_TEST;
    confirmFailureOrDie();
    MOCK_FILE(inputs).reset();

    
    START_TEST;
    MOCK_FUNCTIONS(inputs.inputsTest).funcTakesVectorOfInputs3.expect(&uut, inputsTestList);
    uut.funcTakesVectorOfInputs3(inputsTestList);
    END_TEST;
    confirmFailureOrDie();
    MOCK_FILE(inputs).reset();

    
    std::vector<std::string> testVect1;
    testVect1.push_back("Test1");
    testVect1.push_back("Test2");

    std::vector<std::string> testVect2;
    testVect2.push_back("Test1");
    testVect2.push_back("Test2");

    START_TEST;
    MOCK_FUNCTIONS(inputs.inputsTest).funcTakesComparable.expect(&uut, testVect1);
    uut.funcTakesComparable(testVect2);
    END_TEST;
    confirmSuccessOrDie();
    MOCK_FILE(inputs).reset();

    testVect2.push_back("Test3");
    START_TEST;
    MOCK_FUNCTIONS(inputs.inputsTest).funcTakesComparable.expect(&uut, testVect1);
    uut.funcTakesComparable(testVect2);
    END_TEST;
    confirmFailureOrDie();
    MOCK_FILE(inputs).reset();
    return 0;
}