#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

static int g_mockErrStatus;
static jmp_buf jmp_env; 

void mock_failure(const char *pLocation, unsigned count, const char *pMsg)
{
    fprintf(stderr, "assertion failure in '%s': iter %d, msg: %s", pLocation, count, pMsg);
    longjmp(jmp_env, -1);
}
void mock_fatal(const char *pLocation, unsigned count, const char *pMsg)
{
    mock_failure(pLocation, count, pMsg);
}

#define START_TEST \
    do { \
        g_mockErrStatus = 1; \
        int jmpres = setjmp(jmp_env); \
        if (jmpres == 0) {

#define END_TEST \
        } else { \
            if (jmpres < 0) { \
                g_mockErrStatus = -1; \
            } \
        } \
    } while (0);


// for use in our test files:
#define assert_eq_fatal(arg1, arg2) \
    if (arg1 != arg2) { \
        fprintf(stderr, "value mismatch on line %d\n", __LINE__); \
        exit(1); \
    }


static void confirmSuccessOrDie(void)
{
    if (g_mockErrStatus < 0) {
        exit(1);
    }
    g_mockErrStatus = 1;
}

static void confirmFailureOrDie(void)
{
    if (g_mockErrStatus > 0) {
        exit(1);
    }
    g_mockErrStatus = 1;
}
