#include <stdio.h>
#include "mock.h"
#include "mock_cfg.h"

int main(int argc, char **argv)
{
    outer1::OuterNS1Class1 outerUUT1;
    outer1::inner1::InnerNS1Class1 innerUUT1;
    outer1::OuterNS1Class2 outerUUT2;

    START_TEST;

    MOCK_FUNCTIONS(namespaces.outer1.OuterNS1Class1).testFunc.expect(&outerUUT1);
    outerUUT1.testFunc();

    MOCK_STRUCT(namespaces.outer1.OuterNS1Class1).setCompare([](const outer1::OuterNS1Class1 *arg1, const outer1::OuterNS1Class1 *arg2) {
                                                             return true;
                                                          });
    MOCK_FUNCTIONS(namespaces.outer2).doSomeStuff.expect(outerUUT1);
    MOCK_FUNCTIONS(namespaces.outer2).doSomeStuff.andReturn(123);
    int ret = outer2::doSomeStuff(outerUUT1);
    assert_eq_fatal(ret, 123);

    MOCK_FUNCTIONS(namespaces.outer2).getConstant.expect();
    MOCK_FUNCTIONS(namespaces.outer2).getConstant.andReturn(3.0);
    float val = outer2::getConstant();
    assert_eq_fatal(val, 3.0f);

    END_TEST;
    confirmSuccessOrDie();
    return 0;
}
