#include <stdio.h>
#include "mock.h"
#include "mock_cfg.h"

int main(int argc, char **argv)
{
    OperatorTest uut1;
    OperatorTest uut2;

    auto callApiNode1 = MOCK_OPERATORS(operators.OperatorTest).Call.resolve<OperatorTest (OperatorTest::*)(int, ...)>();
    auto callApiNode2 = MOCK_OPERATORS(operators.OperatorTest).Call.resolve<OperatorTest (OperatorTest::*)(const char *, ...)>();

    START_TEST;
    MOCK_STRUCT(operators.OperatorTest).setCompare([](const OperatorTest *arg1, const OperatorTest *arg2){return true;});
    MOCK_OPERATORS(operators.OperatorTest).LessLess.expect(&uut1, uut2);
    MOCK_OPERATORS(operators.OperatorTest).LessLess.andReturn(uut1);
    uut1 << uut2;
    END_TEST;
    confirmSuccessOrDie();

    START_TEST;
    callApiNode1.expect(&uut1, 2);
    callApiNode1.andReturn(uut1);
    uut1(3); 
    END_TEST;
    confirmFailureOrDie();

    START_TEST;
    callApiNode1.expect(&uut1, 3);
    callApiNode1.andReturn(uut1);
    uut1(3);
    END_TEST;
    confirmSuccessOrDie();

    return 0;
}
