#ifndef __returns_H__
#define __returns_H__

#include <memory>
#include <vector>
#include <cstring>


#include "Optional.hpp"

struct userDeclaredCopyable {
    
    userDeclaredCopyable(const userDeclaredCopyable &) = delete;
    userDeclaredCopyable(userDeclaredCopyable &);
    userDeclaredCopyable(userDeclaredCopyable &&);
};

struct userDeclaredNotCopyable {
    
    userDeclaredNotCopyable(const userDeclaredNotCopyable &) = delete;
    userDeclaredNotCopyable(userDeclaredNotCopyable &&);
};


Optional<userDeclaredNotCopyable> twoLayerTestFunc(void);

struct returnsTest {
    float funcReturnsFloat(void);

    float *funcReturnsPointerToFloat(void);

    float (*funcReturnsPtrToFuncReturningFloat(void))(void);

    float &funcReturnsLValueRef(void);

    float &&funcReturnsRValueRef(void);

    struct podType {
        float field1;
        int field2;
    };

    struct podType funcReturnsPOD(void);

    const struct podType funcReturnsConstPOD(void);

    struct nonPODType {
        float field1;
        int field2;
        virtual void virtualFunc(void);
    };

    struct nonPODType funcReturnsNonPOD(void);

    const struct nonPODType funcReturnsConstNonPOD(void);

    struct noConstructType {
        float field1;
        int field2;
        char name[32];
        virtual void virtualFunc(void);
        noConstructType() = delete;
        noConstructType(const char *pName) { strcpy(name, pName); }
    };

    struct noConstructType funcReturnsNoConstructType(void);

    const struct noConstructType funcReturnsConstNoConstructType(void);

    struct noConstructType &&funcReturnsRValRefToNoConstructType(void);

    const struct noConstructType &&funcReturnsConstRValRefToNoConstructType(void);

    std::unique_ptr<int> funcReturnsUniquePtr(void);

    std::shared_ptr<int> funcReturnsSharedPtr(void);

    userDeclaredCopyable funcReturnsUserCopyable(void);
    userDeclaredNotCopyable funcReturnsUserNotCopyable(void);

    std::vector<std::unique_ptr<int>> funcReturnsVectOfUnique(void);
};

#endif /* __returns_H__ */
