#include <stdio.h>
#include "mock.h"
#include "mock_cfg.h"

int g_global = 123;


notDefaultConstructible notDefaultConstructible::m_exampleInstance("TU-Inst");


notDefaultConstructible::notDefaultConstructible(const char *pArg, int otherArg) :
    m_pArg2("Constructor 2"), m_refArg(g_global)
{
    MOCK_CONSTRUCTOR(variable_init.notDefaultConstructible).shadowCall(this, pArg, otherArg);
}

int main(int argc, char **argv)
{
    START_TEST;
    
    if (notDefaultConstructible::m_pExamplePtr) {
        fprintf(stderr, "Expected m_pExamplePtr to be nullptr");
        return 1;
    }

    if (strcmp(notDefaultConstructible::m_exampleInstance.m_pArg1, "TU-Inst") != 0) {
        fprintf(stderr, "m_pArg should have been initialized");
        return 1;
    }
    MOCK_STRUCT(variable_init.notDefaultConstructible).setCompareEnable(false);
    MOCK_CONSTRUCTOR(variable_init.notDefaultConstructible).expect(NULL, "test", sizeof("test"), 2);

    notDefaultConstructible *pUut = new notDefaultConstructible("test", 2);
    END_TEST;
    confirmSuccessOrDie();
    return 0;
}
