#include <type_traits>

namespace test_ns {

enum test_tags {
    TAG1,
    TAG2
};

};


class agg1
{
public:
    agg1() = delete;
    static int s_ignoreStaticField;
    test_ns::test_tags tag;
    float m_val;
};



class agg2
{
public:
    agg2() = delete;
    static int s_validInt;
    float m_val;
    int &m_refVal;
    const float m_constFloatVal;
};



class agg3
{
public:
    static int s_validInt;
    float m_val;
    const float m_constFloatVal;
};




class agg4 : public agg2
{
public:
    agg4() = delete;
    const agg3 m_agg3Inst;
    test_ns::test_tags tag;
};


class non_agg1
{
public:
    non_agg1();
private:
    test_ns::test_tags tag;
};


class non_agg2
{
public:
    non_agg2() = delete;
private:
    test_ns::test_tags tag;
};



class non_agg3
{
public:
    non_agg3() : m_refVal(s_validInt) { }
    static int s_validInt;
    float m_val;
    int &m_refVal;
};


extern const agg1 agg1_inst[10];



extern const agg2 agg2_inst[10];


extern const agg3 agg3_inst[10];

extern const agg4 agg4_inst;



extern const non_agg1 non_agg1_inst[10];


extern const non_agg2 non_agg2_inst[10];


extern const non_agg3 non_agg3_inst[10];


static_assert(std::is_aggregate_v<agg1>, "agg1 is not an aggregate");
static_assert(std::is_aggregate_v<agg2>, "agg2 is not an aggregate");
static_assert(std::is_aggregate_v<agg3>, "agg3 is not an aggregate");
static_assert(std::is_aggregate_v<agg4>, "agg4 is not an aggregate");
