#include <stdio.h>
#include <string.h>

#include "mock_cfg.h"
#include "mock.h"

ns1::l1str uut_ns1_l1str;
ns1::l1str::l2str uut_ns1_l2str;
ns2::l1str uut_ns2_l1str;
ns2::l1str::l2str uut_ns2_l2str;


void setupForOneCall(void)
{
    MOCK_FILE(resets).mockFunctionPointers();
    MOCK_FUNCTIONS(resets).gmethod1.expect();
    MOCK_FUNCTIONS(resets).gmethod2.expect();

    MOCK_FUNCTIONS(resets.ns1).nsmethod.expect();
    MOCK_NAMESPACE(resets.ns1).mockFunctionPointers();
    MOCK_FUNCTIONS(resets.ns1.l1str).l1method.expect(&uut_ns1_l1str);
    MOCK_STRUCT(resets.ns1.l1str).mockFunctionPointers(&uut_ns1_l1str);
    MOCK_FUNCTIONS(resets.ns1.l1str.l2str).l2method.expect(&uut_ns1_l2str);
    MOCK_STRUCT(resets.ns1.l1str.l2str).mockFunctionPointers(&uut_ns1_l2str);

    MOCK_FUNCTIONS(resets.ns2).nsmethod.expect();
    MOCK_NAMESPACE(resets.ns2).mockFunctionPointers();
    MOCK_FUNCTIONS(resets.ns2.l1str).l1method.expect(&uut_ns2_l1str);
    MOCK_STRUCT(resets.ns2.l1str).mockFunctionPointers(&uut_ns2_l1str);
    MOCK_FUNCTIONS(resets.ns2.l1str.l2str).l2method.expect(&uut_ns2_l2str);
    MOCK_STRUCT(resets.ns2.l1str.l2str).mockFunctionPointers(&uut_ns2_l2str);
}

void callMethodsTwice(void)
{
    gmethod1();
    gmethod1();

    gmethod2();
    gmethod2();

    ns1::nsmethod();
    ns1::nsmethod();

    ns2::nsmethod();
    ns2::nsmethod();

    uut_ns1_l1str.l1method();
    uut_ns1_l1str.l1method();

    uut_ns1_l2str.l2method();
    uut_ns1_l2str.l2method();

    uut_ns2_l1str.l1method();
    uut_ns2_l1str.l1method();

    uut_ns2_l2str.l2method();
    uut_ns2_l2str.l2method();
}


void callFunctionPointersTwice(void)
{
    gfptr1();
    gfptr2();

    ns1::nsfptr();
    ns1::nsfptr();

    ns2::nsfptr();
    ns2::nsfptr();

    uut_ns1_l1str.l1fptr();
    uut_ns1_l1str.l1fptr();

    uut_ns1_l2str.l2fptr();
    uut_ns1_l2str.l2fptr();

    uut_ns2_l1str.l1fptr();
    uut_ns2_l1str.l1fptr();

    uut_ns2_l2str.l2fptr();
    uut_ns2_l2str.l2fptr();
}


int main(int argc, char **argv)
{
    
    START_TEST;
    setupForOneCall();
    callMethodsTwice();
    callFunctionPointersTwice();
    END_TEST;
    confirmFailureOrDie();

    
    
    START_TEST;
    MOCK_FILE(resets).reset();
    callMethodsTwice();
    
    
    
    callFunctionPointersTwice();
    END_TEST;
    confirmSuccessOrDie();

    return 0;
}