#include <stdio.h>
#include <stdlib.h>
#include "mock.h"

void mock_failure(char const *pLoc, unsigned int iter, char const *pMsg)
{
    fprintf(stderr, "location = %s, iteration = %d, msg = %s\n", pLoc, iter, pMsg);
    exit(1);
}

void uut(bar &, const bar &);

int main(int argc, char **argv)
{
    bar testLeft, testRight;

    auto cApi = MOCK_OPERATORS(foo.bar).LessLess.resolve<bar &(bar::*)(const bar &)>();
    cApi.expect(&testLeft, testRight);
    cApi.andReturn(testLeft);
    cApi.setCompare(
        NULL,
        [](const bar &lhs, const bar &rhs) -> bool { return (&lhs == &rhs); }
    );

    uut(testLeft, testRight);
    return 0;
}
