#include <stdio.h>
#include <stdlib.h>
#include "mock.h"

void mock_failure(char const *pLoc, unsigned int iter, char const *pMsg)
{
    fprintf(stderr, "location = %s, iteration = %d, msg = %s\n", pLoc, iter, pMsg);
    exit(1);
}

int main(int argc, char **argv)
{
    int ret = 0;
    char dataVectWrite[4] = {1, 2, 3, 4};
    char dataVectRead[4] = {1, 2, 3, 4};
    char retCheck[4] = {0, 0, 0, 0};
    MOCK_FUNCTIONS(foo).write.expect(dataVectWrite, 4, 4);
    MOCK_FUNCTIONS(foo).write.andReturn(4);

    MOCK_FUNCTIONS(foo).read.expect(4);
    MOCK_FUNCTIONS(foo).read.andReturn(4, dataVectRead, 4);

    ret = write(dataVectWrite, 4);
    if (ret != 4) mock_failure(__FILE__, 0, "invalid write result");

    ret = read(retCheck, 4);
    if (ret != 4) mock_failure(__FILE__, 0, "invalid read result");

    for (int i = 0; i < 4; i++) {
        if (retCheck[i] != dataVectWrite[i]) {
            mock_failure(__FILE__, i, "invalid read result");
        }
    }
    return 0;
}
