#include <gtest/gtest.h>
#include <memory>

#include "foo.h"
#include "mock.h"

std::unique_ptr<char []> mockErrStr(const char *pLocation, unsigned count, const char *pMsg)
{
    const char *pFmtStr = "mock assertion failure! location: '%s',"
                          " iteration: %d, message: %s";
    size_t n = snprintf(NULL, 0, pFmtStr, pLocation, count, pMsg);
    std::unique_ptr<char []> outStrBuf(new char[n+1]);
    snprintf(outStrBuf.get(), n+1, pFmtStr, pLocation, count, pMsg);
    return outStrBuf;
}

void mock_failure(const char *pLocation, unsigned count, const char *pMsg)
{
    ADD_FAILURE() << mockErrStr(pLocation, count, pMsg).get();
}

void mock_fatal(const char *pLocation, unsigned count, const char *pMsg)
{
    FAIL() << mockErrStr(pLocation, count, pMsg).get();
    exit(1);
}


class MimiccPoC : public ::testing::Test {
protected:
    void SetUp() override {
        MOCK_FILE(foo).reset();
    }

    void TearDown() override { }
};


// passing test
TEST_F(MimiccPoC, BeatlesGood)
{
    const char *pVect[] = {"Paul", "John", "George", "Ringo"};
    std::array<std::unique_ptr<std::string>, 4> namesVect;
    for (unsigned i = 0; i < namesVect.size(); i++) {
        namesVect[i] = std::make_unique<std::string>(pVect[i]);
    }

    bar uut;
    MOCK_FUNCTIONS(foo.bar).getNames.expect(&uut);
    MOCK_FUNCTIONS(foo.bar).getNames.andReturn(std::move(namesVect));

    std::array<std::unique_ptr<std::string>, 4> retNames = uut.getNames();
    for (unsigned i = 0; i < namesVect.size(); i++) {
        ASSERT_TRUE(pVect[i] == *retNames[i]);
    }
}

// failing test
TEST_F(MimiccPoC, BeatlesBad)
{
    const char *pVect[] = {"Paul", "John", "George", "Ringo"};
    std::array<std::unique_ptr<std::string>, 4> namesVect;
    for (unsigned i = 0; i < namesVect.size(); i++) {
        namesVect[i] = std::make_unique<std::string>(pVect[i]);
    }

    bar uut;
    MOCK_FUNCTIONS(foo.bar).getNames.expect(&uut);
    MOCK_FUNCTIONS(foo.bar).getNames.andReturn(std::move(namesVect));

    std::array<std::unique_ptr<std::string>, 4> retNames = uut.getNames();
    for (unsigned i = 0; i < namesVect.size(); i++) {
        ASSERT_TRUE(pVect[i] == *retNames[i]);
    }

    // note: one too many calls:
    std::array<std::unique_ptr<std::string>, 4> oops = uut.getNames();
}

