#include <stdio.h>
#include <stdlib.h>

#include "mock-drv.h"
#include "uut.h"

void mock_failure(const char *pLocation, unsigned count, const char *pMsg)
{
    fprintf(stderr, "assertion failure in '%s': iter %d, msg: %s", pLocation, count, pMsg);
    exit(1);
}


int main(int argc, char **argv) {
    driver_t mock_drv;
    char mock_ret_data[] = "HELLO";

    MOCK_FUNCTIONS(drv).driver_init.expect(&mock_drv, 0);
    MOCK_FUNCTIONS(drv).driver_init.andReturn(SUCCESS);

    MOCK_FUNCTIONS(drv).driver_read.expect(&mock_drv, 0, 32);
    MOCK_FUNCTIONS(drv).driver_read.andReturn(SUCCESS, mock_ret_data, sizeof(mock_ret_data));

    char actual_ret[8];
    state_t res = connect(&mock_drv);
    if (res != STATE_CONNECTED) {
        fprintf(stderr, "Test failed, expected CONNECTED, got: %d\n", res);
        return 1;
    }
    printf("SUCCESS\n");
    return 0;
}