#include <string.h>

#include "drv.h"
#include "uut.h" /* not needed for this example, but declares connect(), etc. */

state_t connect(driver_t *drv) {
    char ret_buf[32];
    error_t res;

    res = driver_init(drv);
    if (res != SUCCESS) {
        return STATE_ERROR;
    }
    res = driver_read(drv, ret_buf, sizeof(ret_buf));
    if (res != SUCCESS) {
        return STATE_ERROR;
    }
    if (strncmp(ret_buf, "HELLO", sizeof(ret_buf)) == 0) {
        return STATE_CONNECTED;
    }

    return STATE_IDLE;
}