#include <stdio.h>
#include <stdlib.h>

#include "mock.h"

extern void print(const struct fops *drv, char *data, unsigned amt);

void mock_failure(const char *pLocation, unsigned count, const char *pMsg)
{
    fprintf(stderr, "assertion failure in '%s': iter %d, msg: %s", pLocation, count, pMsg);
    exit(1);
}


int main(int argc, char **argv) {
    struct fops drv;
    char buf[32];

    MOCK_STRUCT(fops.fops).mockFunctionPointers(&drv);
    MOCK_VARIABLES(fops.fops).open.expect();
    MOCK_VARIABLES(fops.fops).open.andReturn(0);

    MOCK_VARIABLES(fops.fops).write.expect(buf, 0, sizeof(buf));
    MOCK_VARIABLES(fops.fops).write.andReturn(sizeof(buf));

    print(&drv, buf, sizeof(buf));
    printf("SUCCESS\n");
    return 0;
}