# Example of using Mimicc with GoogleTest

Inspiration comes from the GoogleTest [Quickstart: CMake](https://google.github.io/googletest/quickstart-cmake.html) tutorial

To build this the Mimicc way:

```
source <path-to-mimicc-root>/usr/local/share/mimicc/mimicc-env
cmake -S . -B build -DCMAKE_C_COMPILER=clang -DCMAKE_CXX_COMPILER=clang++
cmake --build build
end_mimicc
```

To run the tests, you can either use the `ctest` executable, or run the googletest executable. In either case ideally the test should be configured to stop when failures are encountered.

With ctest:

```
cd build && ctest --stop-on-failure
```

With googletest:

```
./build/mimicc_test --gtest_break_on_failure
```
