#include <cstring>
#include <memory>

#include "CppUTest/CommandLineTestRunner.h"
#include "CppUTest/TestHarness.h"

std::unique_ptr<char []> mockErrStr(const char *pLocation, unsigned count, const char *pMsg)
{
    const char *pFmtStr = "mock assertion failure! location: '%s',"
                          " iteration: %d, message: %s";
    size_t n = snprintf(NULL, 0, pFmtStr, pLocation, count, pMsg);
    std::unique_ptr<char []> outStrBuf(new char[n+1]);
    snprintf(outStrBuf.get(), n+1, pFmtStr, pLocation, count, pMsg);
    return outStrBuf;
}

void mock_fatal(const char *pLocation, unsigned count, const char *pMsg) {
    FAIL_TEST(mockErrStr(pLocation, count, pMsg).get());
}

int main(int argc, char **argv)
{
    return RUN_ALL_TESTS(argc, argv);
}
