#include <iostream>

#include "foo.h"
#include "mock.h"


void mock_failure(const char *pLocation, unsigned count, const char *pMsg)
{
    fprintf(stderr, "assertion failure in '%s': iter %d, msg: %s", pLocation, count, pMsg);
    exit(1);
}

int main(int argc, char **argv)
{
    std::array<std::unique_ptr<std::string>, 4> namesVect;
    namesVect[0] = std::make_unique<std::string>("Paul");
    namesVect[1] = std::make_unique<std::string>("John");
    namesVect[2] = std::make_unique<std::string>("George");
    namesVect[3] = std::make_unique<std::string>("Ringo");

    bar uut;
    MOCK_FUNCTIONS(foo.bar).getNames.expect(&uut);
    MOCK_FUNCTIONS(foo.bar).getNames.andReturn(std::move(namesVect));

    std::array<std::unique_ptr<std::string>, 4> retNames = uut.getNames();
    for (auto i = retNames.begin(); i != retNames.end(); ++i) {
        std::cout << **i << "\n";
    }
    return 0;
}
