#ifndef __DRV_H__
#define __DRV_H__

#include <stdint.h>

typedef int error_t;
#define SUCCESS 0
#define ERROR   1

typedef struct driver {
    uint32_t handle;
    uint8_t buf[1024];
    uint16_t readIdx;
} driver_t;

/*!
 * @brief Initialize the driver
 * @param[in] drv Pointer to the driver instance
 */
error_t driver_init(driver_t *drv);

/*!
 * @brief Buffered read from the device
 * @param[in] drv Pointer to the driver instance
 * @param[out] ret_buf Pointer to where the consumed data should be stored
 * @param[in] amt The amount of data to read
 */
error_t driver_read(driver_t *drv, char *ret_buf, unsigned amt);

#endif /* __DRV_H__ */