#include <iostream>

#include "foo.h"
#include "mock.h"

#include "CppUTest/TestHarness.h"

TEST_GROUP(MimiccPoC)
{
    void setup()
    {
        MOCK_FILE(foo).reset();
    }
};

// passing test
TEST(MimiccPoC, BeatlesGood)
{
    const char *pVect[] = {"Paul", "John", "George", "Ringo"};
    std::array<std::unique_ptr<std::string>, 4> namesVect;
    for (unsigned i = 0; i < namesVect.size(); i++) {
        namesVect[i] = std::make_unique<std::string>(pVect[i]);
    }

    bar uut;
    MOCK_FUNCTIONS(foo.bar).getNames.expect(&uut);
    MOCK_FUNCTIONS(foo.bar).getNames.andReturn(std::move(namesVect));

    std::array<std::unique_ptr<std::string>, 4> retNames = uut.getNames();
    for (unsigned i = 0; i < namesVect.size(); i++) {
        CHECK_TRUE(pVect[i] == *retNames[i]);
    }
}

// failing test
TEST(MimiccPoC, BeatlesBad)
{
    const char *pVect[] = {"Paul", "John", "George", "Ringo"};
    std::array<std::unique_ptr<std::string>, 4> namesVect;
    for (unsigned i = 0; i < namesVect.size(); i++) {
        namesVect[i] = std::make_unique<std::string>(pVect[i]);
    }

    bar uut;
    MOCK_FUNCTIONS(foo.bar).getNames.expect(&uut);
    MOCK_FUNCTIONS(foo.bar).getNames.andReturn(std::move(namesVect));

    std::array<std::unique_ptr<std::string>, 4> retNames = uut.getNames();
    for (unsigned i = 0; i < namesVect.size(); i++) {
        CHECK_TRUE(pVect[i] == *retNames[i]);
    }

    // note: one too many calls:
    std::array<std::unique_ptr<std::string>, 4> oops = uut.getNames();
}

